<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('candidate_profiles', function (Blueprint $table) {
            $table->text('bio')->nullable()->after('Experience');
            $table->json('photos')->nullable()->after('bio');
            $table->json('references')->nullable()->after('photos');
            $table->boolean('verified_by_admin')->nullable()->after('references');
            $table->decimal('ratings_avg', 5, 2)->nullable()->after('verified_by_admin');
            $table->boolean('is_active')->nullable()->after('ratings_avg');
        });
    }

    public function down()
    {
        Schema::table('candidate_profiles', function (Blueprint $table) {
            $table->dropColumn(['bio', 'photos', 'references', 'verified_by_admin', 'ratings_avg', 'is_active']);
        });
    }
};
